/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.util.StringTokenizer;
import java.util.Vector;
import mlsoft.mct.MlGrid;
import mlsoft.mct.MlGridEvent;
import mlsoft.mct.MlGridListener;
import mlsoft.mct.MlResources;

public class Grid
extends MlGrid
implements MlGridListener {
    private Vector listeners;
    private int gridWidth;
    private int gridHeight;
    private int fontHeight;
    private int[] columnWidths;
    private int charWidth;
    private int width;
    private FontMetrics metrics;

    public Grid() {
        this.enable(new Ml31Key());
        this.metrics = this.getFontMetrics(this.getFont());
        this.fontHeight = this.metrics.getHeight();
        this.charWidth = this.metrics.charWidth('0');
        MlResources mlResources = new MlResources();
        mlResources.add("horizontalSizePolicy", 1);
        mlResources.add("verticalSizePolicy", 1);
        mlResources.add("headingRows", 1);
        mlResources.add("autoSelect", false);
        mlResources.add("useAverageFontWidth", false);
        mlResources.add("allowColumnResize", true);
        this.setValues(mlResources);
        mlResources.clear();
        mlResources.add("rowType", "CONTENT");
        mlResources.add("cellDefaults", true);
        mlResources.add("cellAlignment", "ALIGNMENT_CENTER");
        mlResources.add("cellBackground", new Color(0, 0, 75));
        mlResources.add("cellForeground", Color.white);
        mlResources.add("columnSizePolicy", 1);
        mlResources.add("highlightThickness", 0);
        this.setValues(mlResources);
        this.columnWidths = new int[this.getColumns()];
        this.addMlGridListener(this);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setColumnWidths() {
        this.getBounds();
        int n = this.getColumns();
        int n2 = this.getRows();
        MlResources mlResources = new MlResources();
        this.columnWidths = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.columnWidths[n3] = ((String)this.getCellValue(0, 0, 1, n3, "cellString")).length() + 2;
            int n4 = 0;
            while (n4 < n2) {
                String string = (String)this.getCellValue(n4, n3, "cellString");
                if (string != null) {
                    this.columnWidths[n3] = Math.max(this.columnWidths[n3], string.length() + 2);
                }
                ++n4;
            }
            this.columnWidths[n3] = Math.min(this.columnWidths[n3], 40);
            this.width += this.columnWidths[n3];
            mlResources.clear();
            mlResources.add("column", n3);
            mlResources.add("columnSizePolicy", 1);
            mlResources.add("columnWidth", this.columnWidths[n3]);
            this.setValues(mlResources);
            ++n3;
        }
        super.doLayout();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = 0;
        while (n < this.getColumns()) {
            dimension.width += this.columnWidths[n];
            ++n;
        }
        return dimension;
    }

    public Dimension getMyPreferredSize() {
        int n = this.getIntValue("visibleColumns");
        int n2 = this.getIntValue("visibleRows");
        int n3 = this.getIntValue("headingRows");
        System.out.println("Heading rows=" + n3);
        System.out.println("Visible rows=" + n2 + " cols=" + n);
        int n4 = this.getIntValue("shadowThickness");
        System.out.println("Shadow thickness =" + n4);
        System.out.println("Font Height =" + this.fontHeight);
        System.out.println("Cell Bottom Margin =" + this.getIntValue("cellBottomMargin"));
        int n5 = this.getIntValue("highlightThickness");
        System.out.println("Highlight Thickness =" + n5);
        int n6 = n2 * this.fontHeight;
        n6 += n2 + (n4 + n5) * 2;
        n6 += n3 * this.fontHeight;
        n6 += n3 + (n4 + n5) * 2;
        n6 += this.getIntValue("scrollbarSize");
        System.out.println("Char Width =" + this.charWidth);
        int n7 = 0;
        int n8 = 0;
        while (n8 < n) {
            int n9 = (Integer)this.getColumnValue(n8, "columnWidth");
            n7 += this.charWidth * n9;
            System.out.println("Width: char=" + n9 + " pixels=" + this.charWidth * n9);
            n7 += (n4 + n5) * 2;
            ++n8;
        }
        n7 += (n4 + n5) * 2;
        return new Dimension(n7 += this.getIntValue("scrollbarSize"), n6);
    }

    public void setHeadings(String string) {
        MlResources mlResources = new MlResources();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        this.setValue("layoutFrozen", true);
        this.addColumns(1, -1, stringTokenizer.countTokens());
        this.setStrings(0, 0, 1, 0, string);
        this.setValue("layoutFrozen", false);
        mlResources.clear();
        mlResources.add("rowType", "HEADING");
        mlResources.add("row", 0);
        mlResources.add("cellBackground", SystemColor.textHighlight);
        mlResources.add("cellForeground", SystemColor.textHighlightText);
        super.setValues(mlResources);
        System.out.println("Set headings in table to new colors");
    }

    public void setVisibleRows(int n) {
        super.addRows(1, -1, n);
    }

    public void deleteAllRows() {
        super.deleteAllRows(1);
    }

    public void onGridEvent(MlGridEvent mlGridEvent) {
        if (mlGridEvent.getType() == 5016) {
            System.out.println("Grid event captured in EuiGrid");
            EuiGridEvent euiGridEvent = new EuiGridEvent(this, 2001, mlGridEvent.getRow(), mlGridEvent.getColumn());
            if (this.listeners != null) {
                int n = 0;
                while (n < this.listeners.size()) {
                    EuiGridListener euiGridListener = (EuiGridListener)this.listeners.elementAt(n);
                    euiGridListener.onEuiGridEvent(euiGridEvent);
                    ++n;
                }
            }
        }
    }

    public synchronized void addEuiGridListener(EuiGridListener euiGridListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(euiGridListener);
    }

    public synchronized void removeEuiGridListener(EuiGridListener euiGridListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(euiGridListener);
        }
    }
}

